typedef struct pattern {
  enum {INCLUDE, EXCLUDE} type;
  char *pattern;
  struct pattern *next;
} *Pattern;
typedef struct profile {
  char *profile;
  char *root1, *root2;
  char id1[32 +1];
  char id2[32 +1];
  char *path1, *path2;
  filetype type1, type2;
  pid_t child1, child2;
  FILE *to1, *from1;
  FILE *to2, *from2;
  int protocol;
  
 _Bool 
      batch_mode, quiet;
  
 _Bool 
      reset_logs, statistics;
  
 _Bool 
      compression, keep_going;
  
 _Bool 
      use_shortcuts;
  
 _Bool 
      nocase;
  Pattern patterns;
  time_t start;
  long long ntotal, ntodo;
  long long sent1, sent2;
  char conflict_resolution;
} *Profile;
extern void init_profile(Profile p);
extern void add_exclusion(Profile profile, const char *pattern);
extern void add_inclusion(Profile profile, const char *pattern);
extern void read_profile(Profile profile);
extern _Bool 
           is_excluded(Profile profile, const char *path);
