/*
  read_link() is called by serve1() to read what a symlink points
  to and output it to stream out.
*/

#include "stdincls.h"
#include "errcodes.e"
#include "types.e"
#include "print.e"
#include "export.h"


/* read_link -- retrieve and print the contents of a symlink */
EXPORT void read_link(FILE *out, const char *root, const char *arg)
{
  char buf[FILENAME_MAX+1], path[FILENAME_MAX+1];
  ssize_t n;

  /* arg points to the argument of the "readlink" command. It may be empty. */
  /* If root is a directory, it ends in '/' */
  if (!make_absolute(root, arg, path))
    print(out, "? %03d Path too long\n", EC_TOOLONG);
  else if ((n = readlink(path, buf, sizeof(buf) - 1)) == -1)
    print(out, "? %03d %s\n", EC_SERVER + errno, strerror(errno));
  else {
    buf[n] = '\0';
    print(out, "= %s\n", buf);
  }
}
