:

# Check that r2sync correctly deletes a file.

# Create two directories.
#
trap 'rm -rf $TMPDIR1 $TMPDIR2' 0
TMPDIR1=`mktemp -d /tmp/test-XXXXXX` || exit 1
TMPDIR2=`mktemp -d /tmp/test-XXXXXX` || exit 1

# Put some files in TMPDIR1.
#
echo "Test" >$TMPDIR1/test-file-1
echo "Test test" >$TMPDIR1/test-file-2
echo "Test test test" >$TMPDIR1/test-file-3

# Let r2sync copy them to TMPDIR2.
#
./r2sync -b -c '>' $TMPDIR1 $TMPDIR2 || exit 1

# Check that the files exist in TMPDOIR2 now.
#
cmp $TMPDIR1/test-file-1 $TMPDIR2/test-file-1 || exit 1
cmp $TMPDIR1/test-file-2 $TMPDIR2/test-file-2 || exit 1
cmp $TMPDIR1/test-file-3 $TMPDIR2/test-file-3 || exit 1

# Remove a test-file-2 from TMPDIR1 and sync again.
#
rm $TMPDIR1/test-file-2
./r2sync -b $TMPDIR1 $TMPDIR2 || exit 1

# Check that test-file-2 no longer exists.
#
test -f $TMPDIR2/test-file-2 && exit 1

# Remove the logs.
#
./r2sync -b -r $TMPDIR1 $TMPDIR2 || exit 1

