:

# Check that a symlink is correctly copied.

set -vx

ok=true

trap 'rm -rf $TMPDIR1 $TMPDIR2' 0
TMPDIR1=`mktemp -d /tmp/test-XXXXXX` || exit 1
TMPDIR2=`mktemp -d /tmp/test-XXXXXX` || exit 1

mkdir -p $TMPDIR1/sub1/sub2
echo Test >$TMPDIR1/sub1/sub2/test1
ln -s $TMPDIR1/sub1/sub2/test1 $TMPDIR1/sub1/sub2/test2

./r2sync -b -c '>' $TMPDIR1 $TMPDIR2 || ok=false

diff -u $TMPDIR1/sub1/sub2/test2 $TMPDIR2/sub1/sub2/test2 || ok=false

./r2sync -r -b $TMPDIR1 $TMPDIR2 || ok=false

$ok
