:

# Test if r2sync computes the checksums correctly under protocol
# 1. This test is the same as test002, but uses the "update0" command.

trap 'rm -rf $TMPDIR' 0
TMPDIR=`mktemp -d /tmp/test-XXXXXX` || exit 1

# Get the real path of TMPDIR
TMPDIR=`cd -P $TMPDIR; echo $PWD`

echo "The quick brown fox jumps over the lazy dog" | tr -d '\n' >$TMPDIR/test1
echo "The quick brown fox jumps over the lazy dog." | tr -d '\n' >$TMPDIR/test2
touch $TMPDIR/test3
echo "a" | tr -d '\n' >$TMPDIR/test4
echo "abc" | tr -d '\n' >$TMPDIR/test5
echo "message digest" | tr -d '\n' >$TMPDIR/test6
echo "abcdefghijklmnopqrstuvwxyz" | tr -d '\n' >$TMPDIR/test7
echo "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" | tr -d '\n' >$TMPDIR/test8
echo "12345678901234567890123456789012345678901234567890123456789012345678901234567890" | tr -d '\n' >$TMPDIR/test9

HELLO=`./test-case`

cat >$TMPDIR/expected <<EOF
$HELLO
OK
OK
directory $TMPDIR/
5ba20fd9 9e107d9d372bb6826bd81d3542a419d6 43
.
6ba91007 e4d909c290d0fb1ca068ffaddf22cbd0 44
.
.
610061 0cc175b9c0f1b6a831c399e269772661 1
.
24a0126 900150983cd24fb0d6963f7d28e17f72 3
.
29670585 f96b697d7cb7938d525a2f31aaf161d0 14
.
906c0b1f c3fcd3d76192e4007dfb496cca67e13b 26
.
8a7f150b d174ab98d277d9f5a5611c2c9f419d9f 62
.
97481068 57edf4a22be3c955ac49da2e2107b67a 80
.
OK
EOF

# The input for the rsync daemon sets the protocol version to 1, an
# arbitrary remote, the temporary directory as local target, and then
# asks for the signatures of the files we created above. Instead of a
# delta, it sends an error.
./r2sync -d >$TMPDIR/output <<EOF
version 1
remote a
local $TMPDIR
update0 700 644 0 0 test1
? 500 Not found
update0 700 644 0 0 test2
? 500 Not found
update0 700 644 0 0 test3
? 500 Not found
update0 700 644 0 0 test4
? 500 Not found
update0 700 644 0 0 test5
? 500 Not found
update0 700 644 0 0 test6
? 500 Not found
update0 700 644 0 0 test7
? 500 Not found
update0 700 644 0 0 test8
? 500 Not found
update0 700 644 0 0 test9
? 500 Not found
reset
quit
EOF

diff -u $TMPDIR/expected $TMPDIR/output
