/*
  check_root_compatibility() is called by client() to check if the two
  roots to synchronize are either both files or both directories. The
  function will return false and print an error if they are anything
  else.
*/

#include "stdincls.h"
#include "types.e"
#include "c-profile.e"


/* check_root_compatibility -- check if root1 and root2 are of the same type */
EXPORT bool check_root_compatibility(Profile profile)
{
  /* See if we have two files or two directories */
  if (profile->type1 == IS_OTHER) {
    warnx(_("%s is not a file or a directory"), profile->root1);
    return false;
  }
  if (profile->type2 == IS_OTHER) {
    warnx(_("%s is not a file or a directory"), profile->root2);
    return false;
  }
  if (profile->type1 != profile->type2) {
    warnx(_("Cannot synchronize a file with a directory"));
    return false;
  }
  return !signaled;		/* True unless a signal handler set a flag */
}
