:

# Test if r2sync honors the --keep-going option in combination with
# --noshortcuts.

# Make two directories and make two files in one of them. The file
# that is alphabetically earlier is set to be unreadable.
#
trap 'rm -rf $TMPDIR1 $TMPDIR2' 0
TMPDIR1=`mktemp -d /tmp/keep001-1-XXXXXX` || exit 1
TMPDIR2=`mktemp -d /tmp/keep001-2-XXXXXX` || exit 1
echo "This is the first file" >$TMPDIR1/aaaa
echo "This is the second file" >$TMPDIR1/zzzz
chmod a-r $TMPDIR1/aaaa

# Run r2sync to synchronize the two directories. It should give an
# error about failure to update aaaa, but the -k option should ensure
# that it continues with file zzzz.
#
./r2sync -b -k -c '>' -q -n $TMPDIR1 $TMPDIR2

# Check that r2sync exited with an error. And check that file zzzz has
# been copied.
#
if [ $? = 0 ]; then
  echo "r2sync unexpectedly reported success" >&2
  result=false
elif ! cmp -s $TMPDIR1/zzzz $TMPDIR2/zzzz; then
  echo "r2sync failed to copy file zzzz" >&2
  result=false
else
  result=true
fi

# Remove the store files.
#
./r2sync -r -b -k -q $TMPDIR1 $TMPDIR2

$result
