/*
  Program to test the generic hash functions in hash.c

  The program reads lines from stdin. The first character of each line
  is a '+', '-', '?' or '!'.

  A '+' indicates an entry to add: The text after the '+' until the
  first space is a key, the rest of the line is data. Text will be
  truncated to the given key and data lengths.

  A '-' indicates an entry to delete. It is followed by a key.

  A '?'  indicates an entry to look up. It is followed by a key. The
  program will print a line with either "No" is the key was not found
  or "Yes" followed by a space and the retrieved data.

  A '!' tells the program to output all keys and entries. It will
  print lines consisting of a '+' followed by a key, followed by a
  space and the data.
*/

#include "stdincls.h"
#include "s-hash.e"

#define DSIZE 100

int main(int argc, char *argv[])
{
  char d[DSIZE], *k, *line = NULL, *p;
  size_t linesize = 0, klen, rlen;
  hashcursor cursor;
  hashtable table;
  void *r;

  table = hash_create(NULL, NULL);

  while (getline(&line, &linesize, stdin) >= 0) {
    switch (line[0]) {
    case '+':
      p = line + 1;
      k = strdup(strsep(&p, " \n"));
      memset(d, 0, DSIZE);
      strncpy(d, strsep(&p, "\n"), 99);
      if (!(hash_put(table, k, strlen(k) + 1, d, DSIZE))) err(EX_OSERR, NULL);
      break;
    case '-':
      p = line + 1;
      k = strsep(&p, " \n");
      hash_del(table, k, strlen(k) + 1);
      break;
    case '?':
      p = line + 1;
      k = strsep(&p, " \n");
      if ((r = hash_get(table, k, strlen(k) + 1, &rlen)))
	printf("Yes %s\n", (char*)r);
      else
	printf("No\n");
      break;
    case '!':
      if (!(cursor = hash_cursor(table))) err(EX_OSERR, NULL);
      while ((k = hash_next(cursor, &klen)))
	printf("+%s %s\n", k, (char*)hash_get(table, k, klen, &rlen));
      break;
    default:
      errx(EX_DATAERR, "Illegal input '%c'", line[0]);
    }
  }
  return 0;
}



