:

# Test r2sync running in batch mode with option -c.

trap 'rm -rf $TMPDIR1 $TMPDIR2' 0
TMPDIR1=`mktemp -d /tmp/test-XXXXXX` || exit 1
TMPDIR2=`mktemp -d /tmp/test-XXXXXX` || exit 1

ok=true

# Create two files in $TMPDIR1 and synchronize them to $TMPDIR2
#
echo "File 1" >$TMPDIR2/file-1
echo "File 2" >$TMPDIR2/file-2
./r2sync -b $TMPDIR1 $TMPDIR2 || ok=false

# Check that the files exist in $TMPDIR2 and are the same.
#
cmp $TMPDIR1/file-1 $TMPDIR2/file-1 || ok=false
cmp $TMPDIR1/file-2 $TMPDIR2/file-2 || ok=false

# Modify a file on both sides and synchronize again.
#
echo "Updated file 1 on target 1" >$TMPDIR1/file-1
echo "Updated file 1 on target 2" >$TMPDIR2/file-1
./r2sync -b $TMPDIR1 $TMPDIR2 || ok=false

# Check that the files in $TMPDIR1 and $TMPDIR2 are still not the same.
#
if cmp $TMPDIR1/file-1 $TMPDIR2/file-1; then ok=false; fi

# Now synchronize with a conflict-resolution action.
#
./r2sync -b -c '>' $TMPDIR1 $TMPDIR2 || ok=false

# Check that the files in $TMPDIR1 and $TMPDIR2 are new the same...
#
cmp $TMPDIR1/file-1 $TMPDIR2/file-1 || ok=false
cmp $TMPDIR1/file-2 $TMPDIR2/file-2 || ok=false

# ... and that the version in TMPDIR1 won.
#
grep "Updated file 1 on target 1" $TMPDIR2/file-1 || ok=false

# Let r2sync remove the log file.
#
./r2sync -b -r $TMPDIR1 $TMPDIR2 || ok=false

$ok
