:

# Simulate a server on a case-insensitive file system that has files
# that differ only in case; and another on a case-sensitive file
# system. r2sync must report an error and fail.

if ! type nc; then exit 77; fi

trap 'rm -f $FIFO1 $FIFO2 $TMP1' 0
FIFO1=/tmp/case1-$$
FIFO2=/tmp/case2-$$
TMP1=`mktemp /tmp/test-XXXXXX` || exit 1

mkfifo $FIFO1 $FIFO2

# Start a simple server simulating a case-insensitive file system.
# Some versions of nc require the -p options, others forbid it.
#
(nc -l -p 5594 || nc -l 5594) <$FIFO1 | \
  (
    echo "ready 00000000000000000000000000000000 1 nocase"
    while read cmd arg && [ "$cmd" != "quit" ]; do
      echo 1: $cmd $atg >&2
      case $cmd in
	version) echo OK;;
	remote) echo OK;;
	local) echo directory;;
	list)
	  echo "comparing"
	  sleep 0.1
	  echo "= 100644 1519479844 5168 abc"
	  sleep 0.1
	  echo ".";;
	*) echo "? 404 Unknown command";;
      esac
    done
  ) >$FIFO1 &

# Start another simple server, but without "nocase" and with two files
# that differ only in case.
#
(nc -l -p 5595 || nc -l 5595) <$FIFO2 | \
  (
    echo "ready 00000000000000000000000000000001 1"
    while read cmd arg && [ "$cmd" != "quit" ]; do
      echo 2: $cmd $arg >&2
      case $cmd in
	version) echo OK;;
	remote) echo OK;;
	local) echo directory;;
	list)
	  echo "comparing"
	  sleep 0.1
	  echo "= 100644 1519479844 5168 ABC"
	  echo "= 100644 1519479844 5168 abc"
	  sleep 0.1
	  echo ".";;
	*) echo "? 404 Unknown command";;
      esac
    done
  ) >$FIFO2 &

sleep 0.5			# Give processes time to start

./r2sync -b r2sync://localhost:5594/ r2sync://localhost:5595/
result=$?  

rm -f $FIFO1 $FIFO2
kill %1
kill %2
wait

if [ $result = 0 ]; then echo "Fail: r2sync did not detect an error"; exit 1; fi
