:

# Test if r2sync as a daemon correctly handles redundant "remote" and
# "local" commands.

trap 'rm -rf $TMPDIR $EXPECTED $INPUT $OUTPUT' 0
TMPDIR=`mktemp -d /tmp/test-XXXXXX` || exit 1
EXPECTED=`mktemp /tmp/test-XXXXXX` || exit 1
INPUT=`mktemp /tmp/test-XXXXXX` || exit 1
OUTPUT=`mktemp /tmp/test-XXXXXX` || exit 1

# Get the real path of TMPDIR
TMPDIR=`cd -P $TMPDIR; echo $PWD`

HELLO=`./test-case`

cat >$EXPECTED <<EOF
$HELLO
OK
OK
OK
directory $TMPDIR/
OK
creating
.
directory $TMPDIR/
creating
.
EOF

cat >$INPUT <<EOF
version 1
remote a
remote a
local $TMPDIR
reset
list
local $TMPDIR
list
EOF

./r2sync -d <$INPUT >$OUTPUT

diff -u $EXPECTED $OUTPUT
