:

# Test the implementation of the log with the help of the test-store
# program (and test the test-store program itself).

p=path
m=100640
t=1518902092
s=233

set -vx

# Make the store empty.
./test-store test-a test-b reset || exit 1

# An empty store should not have an entry for $p.
./test-store test-a test-b get $p | grep 'Not found' || exit 1

# Put and then get an entry for $p.
./test-store test-a test-b \
	     put $p $m $t $s \
	     get $p | grep "$m $t $s" || exit 1

# The store on disk should still have the entry for $p.
./test-store test-a test-b get $p | grep "$m $t $s" || exit 1

# The store should *only* have the entry for $p.
./test-store test-a test-b list | \
  grep -v 'Store opened' | \
  grep -v "$m $t $s $p" && exit 1

# After adding the same entry again, there should still only be one entry.
# test-store also prints a "Store opened" line, so 2 lines total.
./test-store test-a test-b \
	     put $p $m $t $s \
	     list | wc -l | grep 2 || exit 1

# Empty the store, so that the log file will be removed.
./test-store test-a test-b reset || exit 1
