/*
  delete_files() is called by client() with the lists of files to
  delete on both servers.

  Implementation:

  For all files to delete, delete_files() sends a "del" command to the
  server that should delete the file a "log" commands to the other
  server, so the file gets removed from the log there, too.
*/

#include "stdincls.h"
#include "types.e"
#include "getline.e"
#include "print.e"
#include "c-profile.e"
#include "c-progress.e"


/* delete_files -- delete the given files on both servers */
EXPORT bool delete_files(Profile profile, char *files[], int nfiles)
{
  char *line;
  bool ok;
  int i;

  for (ok = true, i = 0; ok && i < nfiles; i++) {

    /* Feedback to user. For the progress meter, the file counts as 1 byte. */
    if (!profile->quiet)
      status("DEL", files[i], progress_meter(profile, DELBYTES));

    /* Send "del" commands to both servers. */
    ok = false;
    if (print(profile->to1, "del %s\n", files[i]) < 0)	    warn(NULL);
    else if (print(profile->to2, "del %s\n", files[i]) < 0) warn(NULL);
    else if (!(line = getline1(profile->from1)))	    warn(NULL);
    else if (line[0] == '?')				    warnx("%s", line+2);
    else if (!(line = getline1(profile->from2)))	    warn(NULL);
    else if (line[0] == '?')				    warnx("%s", line+2);
    else ok = true;

    if (!profile->quiet) {
      putchar('\r');
      status("DEL", files[i], "");
      putchar('\n');
    }
  }

  return ok;
}
