/*
  set_protocol() is called by client() to tell the two servers the
  version of the protocol to use. This is normally the highest version
  that all three of the client and the two servers understand, but the
  user may override it.
*/

#include "stdincls.h"
#include "types.e"
#include "getline.e"
#include "print.e"
#include "c-profile.e"


/* set_protocol -- set the minimum common protocol version on the servers */
EXPORT bool set_protocol(Profile profile)
{
  char *line;
  bool ok1, ok2;

  /* Tell the servers the highest protocol version to use. */
  ok1 = print(profile->to1, "version %d%s\n", profile->protocol,
	      profile->use_shortcuts ? "" : " noshortcuts") > 0 &&
    (line = getline1(profile->from1)) && line[0] != '?';

  ok2 = print(profile->to2, "version %d%s\n", profile->protocol,
	      profile->use_shortcuts ? "" : " noshortcuts") > 0 &&
    (line = getline1(profile->from2)) && line[0] != '?';

  debug("Protocol version set to %d\n", profile->protocol);

  return ok1 && ok2 && !signaled;
}
