/*
  update_log() is called by serve1() after a "log" command, to update
  the log entry for a file.

  Implementation:

  update_log() calls lstat() to get the data about the file and then
  calls store_put() to store that data in the log, or store_del() if
  the file doesn't exist.
*/

#include "stdincls.h"
#include "print.e"
#include "errcodes.e"
#include "types.e"
#include "s-sumfile.e"
#include "s-store.e"


/* update_log -- update the log entry for a file. */
EXPORT void update_log(FILE *out, char * const root, DB store,
		       const fileinfo info)
{
  store_del(store, info.path);	/* To free memory */
  if (!store_put(store, info))
    print(out, "? %03d %s\n", EC_SERVER + errno, strerror(errno));
  else
    print1(out, "OK\n");
}
