:

# Check that r2sync ignores the -a option under protocol 1.

# Create two directories and temporary file.
#
trap 'rm -rf $TMPDIR1 $TMPDIR2 $TMP' 0
TMPDIR1=`mktemp -d /tmp/test-XXXXXX` || exit 1
TMPDIR2=`mktemp -d /tmp/test-XXXXXX` || exit 1
TMP=`mktemp /tmp/test-XXXXXX` || exit 1

# Put some files in TMPDIR1.
#
echo "Test" >$TMPDIR1/test-file-1
echo "Test test" >$TMPDIR1/test-file-2
echo "Test test test" >$TMPDIR1/test-file-3

# Let r2sync copy them to TMPDIR2.
#
./r2sync -b -c '>' $TMPDIR1 $TMPDIR2 || exit 1

# Modify test-file-2 in both directories in identical ways.
#
echo "Modified" >$TMPDIR1/test-file-2
echo "Modified" >$TMPDIR2/test-file-2
touch -r $TMPDIR1/test-file-1 $TMPDIR2/test-file-2

# Modify test-file-3 in both directories in different ways,
# but with the same size and time.
#
echo "Modified1" >$TMPDIR1/test-file-3
echo "Modified2" >$TMPDIR2/test-file-3
touch -r $TMPDIR1/test-file-3 $TMPDIR2/test-file-3

# Let r2sync synchronize the directories without -a. It should report
# 2 files to synchronize.
#
ok=true
./r2sync -b $TMPDIR1 $TMPDIR2 >$TMP
cat $TMP
echo "==============="
grep -F 'Found 2 files to synchronize' $TMP || ok=false
echo "==============="

# Let r2sync synchronize the directories with -a and protocol 1. It should also report
# 2 files to synchronize.
#
./r2sync -b -a -P 1 $TMPDIR1 $TMPDIR2 >$TMP
cat $TMP
echo "==============="
grep -F 'Found 2 files to synchronize' $TMP || ok=false
echo "==============="

# Remove the logs.
#
./r2sync -b -r $TMPDIR1 $TMPDIR2
echo "==============="

# Report the result.
#
$ok
