:

# Check that -a and -n cannot both be used.

# Create two directories and temporary file.
#
trap 'rm -rf $TMPDIR1 $TMPDIR2 $TMP' 0
TMPDIR1=`mktemp -d /tmp/test-XXXXXX` || exit 1
TMPDIR2=`mktemp -d /tmp/test-XXXXXX` || exit 1
TMP=`mktemp /tmp/test-XXXXXX` || exit 1

# Call r2sync with -a and -n, which should fail. Capture messages.
#
./r2sync -n -a $TMPDIR1 $TMPDIR2 2>$TMP && exit 1

# Check that the message mentions the right error.
#
grep "Autocheck (-a) and noshortcuts (-n) are incompatible" $TMP
