:

# Check that r2sync synchronizes the mode bits and correctly store the
# new mode in the log.

ok=true

# Create two directories.
#
trap 'rm -rf $TMPDIR1 $TMPDIR2' 0
TMPDIR1=`mktemp -d /tmp/test-XXXXXX` || exit 1
TMPDIR2=`mktemp -d /tmp/test-XXXXXX` || exit 1

# Put a file in one of them, give it specific permission bits and let
# r2sync sync it to the other directory.
#
echo "This is a test file." >$TMPDIR1/testfile
chmod 601 $TMPDIR1/testfile
mode1=`ls -l $TMPDIR1/testfile | cut -c1-10`
echo "mode1: $mode1"
./r2sync -b $TMPDIR1 $TMPDIR2				|| ok=false

# Change the permission bits and let r2sync sync the file again.
#
chmod 602 $TMPDIR1/testfile
mode1=`ls -l $TMPDIR1/testfile | cut -c1-10`
echo "mode1: $mode1"
./r2sync -b $TMPDIR1 $TMPDIR2				|| ok=false

# Check that the permission bits of the two files are the same.
#
mode2=`ls -l $TMPDIR2/testfile | cut -c1-10`
echo "mode2: $mode2"
test "$mode1" = "$mode2"				|| ok=false

# Change the permission bits again and synchronize again.
#
chmod 603 $TMPDIR1/testfile
mode1=`ls -l $TMPDIR1/testfile | cut -c1-10`
echo "mode1: $mode1"
./r2sync -b $TMPDIR1 $TMPDIR2				|| ok=false

# Check that the permission bits of the two files are the same.
#
mode2=`ls -l $TMPDIR2/testfile | cut -c1-10`
echo "mode2: $mode2"
test "$mode1" = "$mode2"				|| ok=false

# Remove the log files.
#
./r2sync -b -r $TMPDIR1 $TMPDIR2			|| ok=false

$ok
