#define R2SYNCPROTO  2
#define R2SYNCDIR  ".r2sync"
#define DIGEST_LEN  16
#define MACHINE_ID_LEN  32
typedef enum {
  IS_DIR, IS_FILE, IS_OTHER
} filetype;
typedef struct {
  uint32_t sum;
  unsigned char digest[16];
} suminfo;
typedef struct {
  char status;
  unsigned int mode;
  time_t time;
  long long size;
  suminfo sums;
  char *path;
} fileinfo;
extern int signaled ;
#define _(String)  gettext(String)
#define gettext_noop(String)  String
#define N_(String)  String
#define realloc_more(p, n)  realloc((p), ((n) ? 2 * (n) : 1) * sizeof(*(p)))
extern int cmp_fileinfo(const void *a, const void *b);
extern int cmpcase_fileinfo(const void *a, const void *b);
extern _Bool 
           create_directories(char *path);
extern FILE* create_temp_file(const char *path, char name[
                                                          4096
                                                                      ]);
extern void debug(const char *format,...);
extern _Bool 
           make_absolute(const char *base, const char *path,
     char abspath[
                 4096
                             +1]);
extern _Bool 
           str_to_digest(char * __restrict__ s, unsigned char d[16],
     char ** __restrict__ end);
extern char *digest_to_str(const unsigned char m[16]);
